#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n;
    cin >> n;

    vector<long long> x(n), h(n);
    for (int i = 0; i < n; i++) cin >> x[i];
    for (int i = 0; i < n; i++) cin >> h[i];

    vector<int> id(n);
    iota(id.begin(), id.end(), 0);
    sort(id.begin(), id.end(), [&](int a, int b) {
        return x[a] < x[b];
    });

    vector<long long> xs(n), hs(n);
    for (int i = 0; i < n; i++) {
        xs[i] = x[id[i]];
        hs[i] = h[id[i]];
    }

    vector<double> ans(n, 1e100);

    for (int i = 0; i < n; i++) {
        double xi = xs[i], yi = hs[i];

        for (int j = 0; j < n; j++) {
            if (j == i) continue;
            if (hs[j] >= yi) {
                double dx = xs[j] - xi;
                double dy = hs[j] - yi;
                ans[id[i]] = min(ans[id[i]], sqrt(dx * dx + dy * dy));
            }
        }

        if (i + 1 < n) {
            long long dx = xs[i + 1] - xs[i];
            long long ymin = (hs[i] + hs[i + 1] - dx) / 2;
            long long mid = xs[i] + (hs[i] - ymin);

            for (int k = 0; k <= dx; k++) {
                long long t = xs[i] + k;
                long long y = (t <= mid) ? (hs[i] - (t - xs[i])) 
                                         : (ymin + (t - mid));

                if (y >= yi && t != xi) {
                    double ddx = t - xi;
                    double ddy = y - yi;
                    ans[id[i]] = min(ans[id[i]], sqrt(ddx * ddx + ddy * ddy));
                }
            }
        }
    }

    for (int i = 0; i < n; i++) {
        if (ans[i] > 1e90) cout << -1 << '\n';
        else cout << (long long)llround(ans[i]) << '\n';
    }

    return 0;
}